<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class VariationValue extends Model 
{

    protected $table = 'variation_values';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('variation_id', 'value');

    public function productVariation()
    {
        return $this->hasMany('App\Models\ProductVariationDetail');
    }

    public function variation()
    {
        return $this->belongsTo('App\Models\Variation');
    }

}